/*
 * Decompiled with CFR 0.152.
 */
package com.hoshino.cti.netwrok.packet;

import com.hoshino.cti.Entity.Projectiles.StarDargonAmmo;
import com.hoshino.cti.Modifier.StarDragonHit;
import com.hoshino.cti.util.method.GetModifierLevel;
import com.marth7th.solidarytinker.register.TinkerCuriosModifier;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class StarHitPacket {
    private final UUID mobUUID;

    public StarHitPacket(UUID mobUUID) {
        this.mobUUID = mobUUID;
    }

    public StarHitPacket(FriendlyByteBuf buf) {
        this.mobUUID = buf.m_130259_();
    }

    public void ToByte(FriendlyByteBuf buf) {
        buf.m_130077_(this.mobUUID);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ServerLevel serverLevel = sender.m_9236_();
            Entity mob = serverLevel.m_8791_(this.mobUUID);
            if (mob == null) {
                return;
            }
            ToolStack view = ToolStack.from((ItemStack)sender.m_21205_());
            int starDust = view.getPersistentData().getInt(StarDragonHit.STAR_DUST);
            int waitTick = StarDragonHit.getFreezeTick((IToolStackView)view);
            if (waitTick > 0) {
                sender.m_5661_((Component)Component.m_237113_((String)("\u8fd8\u5728\u51b7\u5374,\u51b7\u5374\u65f6\u957f\u4e3a" + waitTick + "\u79d2")).m_130938_(style -> style.m_178520_(6597117)), true);
                return;
            }
            if (starDust >= 50) {
                view.getPersistentData().putInt(StarDragonHit.STAR_DUST, starDust - 50);
                float damageShouldBe = StarDragonHit.DAMAGE_SHOULD_BE.getOrDefault(sender.m_20148_(), Float.valueOf(10.0f)).floatValue();
                mob.getPersistentData().m_128379_("star_extra_hurt", true);
                StarDragonHit.setFreezeTick((IToolStackView)view, GetModifierLevel.CurioModifierLevel((LivingEntity)sender, TinkerCuriosModifier.BHA_STATIC_MODIFIER.getId()) > 0 ? 8 : 20);
                StarDargonAmmo ammo = new StarDargonAmmo((LivingEntity)sender, (Level)sender.m_9236_(), mob.m_20183_(), damageShouldBe, Math.min(0.21f + (float)starDust / 100.0f * 0.01f, 0.78f));
                sender.m_9236_().m_6269_(null, (Entity)sender, SoundEvents.f_11896_, SoundSource.AMBIENT, 1.0f, 1.0f);
                sender.m_9236_().m_7967_((Entity)ammo);
            }
        });
        return true;
    }
}

